@extends('admin.layout.master')
@section('css')
@stop
@section('body')


    <div class="card">
        <div class="card-header ">
            <h4 class="float-left">{{$page_title}}</h4>
            <a href="{{route('create.team')}}" class="btn btn-success btn-md float-right ">
                <i class="fa fa-plus"></i> Create New
            </a>
        </div>

        {!! Form::model($basic,['route'=>['manage-footer-update'],'method'=>'PUT','role'=>'form','class'=>'form-horizontal','files'=>true]) !!}

        <div class="card-body">

            <div class="row">
                <div class="col-md-12">

                    <div class="form-group{{ $errors->has('team_h') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">Team Title</strong></label>
                        <div class="col-md-12">
                            <input type="text" name="team_h" class="form-control form-control-lg" value="{{ $basic->team_h }}" required >
                            @if ($errors->has('team_h'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('team_h') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="form-group{{ $errors->has('team_p') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">Team Details</strong></label>
                        <div class="col-md-12">
                            <textarea name="team_p" class="form-control" rows="3" required>{{ $basic->team_p }}</textarea>
                            @if ($errors->has('team_p'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('team_p') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                </div>
            </div><!-- row -->

        </div>
        <div class="card-footer ">
            <button class="btn btn-primary btn-block btn-lg" type="submit"> <i class="fa fa-send"></i> Update</button>
        </div>

        {!! Form::close() !!}
    </div>




    <div class="card mt-5">
        <div class="card-body">

        <div class="row">


        @foreach($teams as $key => $data)
            <div class="col-md-4">
                <div class="card">
                    <img src="{{asset('assets/images/our-team/'.$data->image)}}" width="60%" alt="Image"
                         class="card-img-top">


                    <div class="card-body text-center">

                        <h3 class="title">{!! $data->name !!}</h3>
                        <strong>{!! $data->designation !!}</strong>
                    </div>
                    <div class="card-footer text-center">
                        <a class="btn btn-primary " href="{{route('edit.team',$data->id)}}">
                            <i class="fa fa-pencil"></i> Edit
                        </a>
                        <button class="btn btn-danger delete_button"
                                data-toggle="modal" data-target="#DelModal"
                                data-id="{{ $data->id }}">
                            <i class="fa fa-trash"></i> Delete
                        </button>
                    </div>
                </div>
                <br>
            </div>
    @endforeach
    </div>


        </div>
    </div>



    <div class="modal fade" id="DelModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel2"><i class='fa fa-trash'></i> Delete !</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <strong>Are you sure you want to Delete ?</strong>
                </div>

                <div class="modal-footer">
                    <form method="post" action="{{ route('delete.team') }}">
                        {!! csrf_field() !!}
                        {{ method_field('DELETE') }}
                        <input type="hidden" name="id" class="abir_id" value="0">

                        <button type="submit" class="btn btn-success"><i class="fa fa-check"></i> Yes</button>

                        <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-trash"></i> No
                        </button>&nbsp;
                    </form>
                </div>

            </div>
        </div>
    </div>

@stop
@section('script')
    <script>
        $(document).ready(function () {
            $(document).on("click", '.delete_button', function (e) {
                var id = $(this).data('id');
                $(".abir_id").val(id);
            });
        });
    </script>
@stop